using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      // The fonts in this list are sorted alphabetically because no better order is known. I've chosen
      // fonts that MS Word used to display the languages of the test file on my system. It is of course
      // not guaranteed that any of these fonts is available on your system.
      private static String[] ALT_FONTS =
      {
         "Malgun Gothic", // Korean
         "Mangal",        // Hindi or Marathi
         "Nyala",         // Amharic
         "Shonar Bangla", // Bengali
         "Shruti"         // Gurjarati
      };

      private static String GetFileBuffer(String FileName)
      {
         System.IO.FileStream f = new System.IO.FileStream(FileName, System.IO.FileMode.Open, System.IO.FileAccess.Read);
         System.IO.BinaryReader b = new System.IO.BinaryReader(f, System.Text.Encoding.Unicode);
         char[] buffer = new char[f.Length / 2];
         b.Read(buffer, 0, (int)(f.Length >> 1));
         f.Close();
         return new String(buffer);
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);
            // Enable complex text layout
            pdf.SetGStateFlags(TGStateFlags.gfComplexText, false);

            // This is essentially the same example as font_substitution. The only difference is that we provide
            // an alternate font list to improve font substitution.
            int altFonts = pdf.CreateAltFontList();
            pdf.SetAltFonts(altFonts, ALT_FONTS);

            String txt = GetFileBuffer("../../../../test_files/multi_lang.txt");

            pdf.Append();
               // The font must be loaded with cpUnicode.
               pdf.SetFont("Arial", TFStyle.fsRegular, 10.0, true, TCodepage.cpUnicode);
               // Activate the alternate font list
               pdf.ActivateAltFontList(altFonts, true);

               pdf.SetLeading(pdf.GetTypoLeading());
               pdf.WriteFTextEx(50.0, 50.0, pdf.GetPageWidth() - 100.0, pdf.GetPageHeight() - 100.0, TTextAlign.taJustify, txt);
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
